﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Collections;
using DevExpress.Xpf.LayoutControl;
using System.Windows.Data;
using System.Collections.Specialized;

namespace WpfApplication142
{
    public static class FlowLayoutExtensions
    {
        public static readonly DependencyProperty ItemsSourceProperty = DependencyProperty.RegisterAttached("ItemsSource", typeof(IEnumerable), typeof(FlowLayoutExtensions), 
            new UIPropertyMetadata(null, new PropertyChangedCallback(OnItemsSourceChanged)));

        public static IEnumerable GetItemsSource(DependencyObject target)
        {
            return (IEnumerable)target.GetValue(ItemsSourceProperty);
        }
        public static void SetItemsSource(DependencyObject target, IEnumerable value)
        {
            target.SetValue(ItemsSourceProperty, value);
        }
        private static void OnItemsSourceChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            OnItemsSourceChanged(o, (IEnumerable)e.OldValue, (IEnumerable)e.NewValue);
        }
        private static void OnItemsSourceChanged(DependencyObject o, IEnumerable oldValue, IEnumerable newValue)
        {
            FlowLayoutControl layout = o as FlowLayoutControl;
            if (layout != null)
            {

                NotifyCollectionChangedEventHandler collectionChanged = delegate(object s, NotifyCollectionChangedEventArgs e)
                {
                    switch (e.Action)
                    {
                        case NotifyCollectionChangedAction.Add:
                            AddItems(layout, e.NewItems);
                            break;
                        case NotifyCollectionChangedAction.Remove:
                            RemoveItems(layout, e.OldItems);
                            break;
                    }
                };

                // remove event implementation
                if (oldValue != null)
                {
                    INotifyCollectionChanged oldIncc = oldValue as INotifyCollectionChanged;
                    if (oldIncc != null)
                        oldIncc.CollectionChanged -= collectionChanged;
                }
                layout.Children.Clear();

                if (newValue != null)
                {
                    AddItems(layout, newValue);
                    INotifyCollectionChanged incc = newValue as INotifyCollectionChanged;
                    if (incc != null)
                    {
                        incc.CollectionChanged += collectionChanged;
                    }
                }
            }
        }

        private static void AddItems(FlowLayoutControl layout, IEnumerable source)
        {
            foreach (object item in source)
            {
                GroupBox box = new GroupBox { DataContext = item };
                layout.Children.Add(box);
            }
        }

        private static void RemoveItems(FlowLayoutControl layout, IEnumerable source)
        {
            foreach (object item in source)
            {
                GroupBox match = (from gb in layout.Children.OfType<GroupBox>()
                                  where gb.DataContext == item
                                  select gb).FirstOrDefault();
                if (match != null)
                    layout.Children.Remove(match);
            }
        }
        
    }
}
