﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.ComponentModel;

namespace Righthand.RealtimeGraph.Example
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        BindingList<RealtimeGraphItem> items = new BindingList<RealtimeGraphItem>();
        private DispatcherTimer timer;
        private DateTime start;
        private DateTime last;

        public MainWindow()
        {
            InitializeComponent();

            float angle = 135;
            // bind items
            Graph.SeriesSource = items;

            timer = new DispatcherTimer
            {
                Interval = TimeSpan.FromMilliseconds(5)
            };
            timer.Tick += timer_Tick;
            last = start = DateTime.Now;
            timer.IsEnabled = true;
        }

        void timer_Tick(object sender, EventArgs e)
        {
            // add new items each tick
            TimeSpan span = DateTime.Now - last;
            TimeSpan totalSpan = DateTime.Now - start;
            int previousTime = items.Count > 0 ? items[items.Count - 1].Time: 0;
            RealtimeGraphItem newItem = new RealtimeGraphItem
            {
                Time = (int)(previousTime + span.TotalMilliseconds),
                Value = Math.Sin(totalSpan.TotalSeconds / 10f) * 90 + 150
            };

            items.Add(newItem);
            last = DateTime.Now;
        }
    }
}
