﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Roslyn.Services.Editor;
using Roslyn.Compilers.CSharp;

namespace CodeIssue2
{
    public class Autofacaj: ICodeAction
    {
        private ICodeActionEditFactory editFactory;
        private Roslyn.Services.IDocument document;
        private Roslyn.Compilers.CSharp.FieldDeclarationSyntax polje;
        private Roslyn.Compilers.CSharp.ConstructorDeclarationSyntax konstruktor;

        public Autofacaj(ICodeActionEditFactory editFactory, Roslyn.Services.IDocument document, Roslyn.Compilers.CSharp.FieldDeclarationSyntax polje, Roslyn.Compilers.CSharp.ConstructorDeclarationSyntax konstruktor)
        {
            // TODO: Complete member initialization
            this.editFactory = editFactory;
            this.document = document;
            this.polje = polje;
            this.konstruktor = konstruktor;
        }
        public string Description
        {
            get
            {
                if (konstruktor == null)
                {
                    return "Dodaj argument in konstruktorja";
                }
                else
                    return "Dodaj argument";
            }
        }

        public ICodeActionEdit GetEdit(System.Threading.CancellationToken cancellationToken)
        {
            SyntaxTree sintaktičnoDrevo = (SyntaxTree)document.GetSyntaxTree(cancellationToken);
            CompilationUnitSyntax koren = (CompilationUnitSyntax)sintaktičnoDrevo.Root;
            ClassDeclarationSyntax razred = koren.DescendentNodes().OfType<ClassDeclarationSyntax>().Single();

            bool imaAutofacUsing = koren.Usings.Any(u => u.Name.PlainName == "Autofac");
            List<SyntaxNode> zamenjave = new List<SyntaxNode>();
            if (!imaAutofacUsing)
            {
                zamenjave.Add(koren);
            }
            if (konstruktor == null)
                zamenjave.Add(razred);
            else
                zamenjave.Add(konstruktor);

            var noviKoren = koren.ReplaceNodes(
                zamenjave,
                (stari, novi) =>
                {
                    if (stari == koren)
                    {
                        return DodajUsingsAutofac((CompilationUnitSyntax)novi);
                    }
                    else if (stari == razred)
                    {
                        return DodajKonstruktor((ClassDeclarationSyntax)novi);
                    }
                    else if (stari == konstruktor)
                    {
                        return PosodobiKonstruktor((ConstructorDeclarationSyntax)novi);
                    }
                    else
                        return null;
                }
                );

            return editFactory.CreateTreeTransformEdit(document.Project.Solution, sintaktičnoDrevo, noviKoren);
        }

        private ConstructorDeclarationSyntax PosodobiKonstruktor(ConstructorDeclarationSyntax konstruktor)
        {
            var pl = konstruktor.ParameterList;
            List<SyntaxNodeOrToken> novi = new List<SyntaxNodeOrToken>();
            foreach (var p in pl.Parameters)
                novi.Add(p);

            novi.Add(Syntax.Token(SyntaxKind.CommaToken));
            novi.Add(
                Syntax.Parameter(
                                typeOpt: polje.Declaration.Type,
                                identifier: polje.Declaration.Variables[0].Identifier
                            ));

            ParameterListSyntax parametri = pl.Update(
                    pl.OpenParenToken,
                    Syntax.SeparatedList<ParameterSyntax>(novi),
                    pl.CloseParenToken
                );

            BlockSyntax noviBlok = konstruktor.BodyOpt.Update(
                openBraceToken: konstruktor.BodyOpt.OpenBraceToken,
                statements: Syntax.List(konstruktor.BodyOpt.Statements.Concat(
                    new[] {
                        Syntax.ParseStatement(string.Format("this.{0} = {0};", polje.Declaration.Variables[0].Identifier.ValueText))
                    }
                    )),
                closeBraceToken: konstruktor.BodyOpt.CloseBraceToken
                );

            var noviKonstruktor = konstruktor.Update(
                konstruktor.Attributes,
                konstruktor.Modifiers,
                konstruktor.Identifier,
                parametri,
                konstruktor.InitializerOpt,
                noviBlok,
                konstruktor.SemicolonTokenOpt
                );
            var formattedLocalDeclaration = CodeActionAnnotations.FormattingAnnotation.AddAnnotationTo(noviKonstruktor);
            return formattedLocalDeclaration;
        }


        private ClassDeclarationSyntax DodajKonstruktor(ClassDeclarationSyntax razred)
        {
            ConstructorDeclarationSyntax konstruktor = NarediKonstruktorja(razred);
            SyntaxList<MemberDeclarationSyntax> člani = Syntax.List(razred.Members.Concat(new MemberDeclarationSyntax[] { konstruktor }));
            var noviRazred = razred.Update(
                razred.Attributes,
                razred.Modifiers,
                razred.Keyword,
                razred.Identifier,
                razred.TypeParameterListOpt,
                razred.BaseListOpt,
                razred.ConstraintClauses,
                razred.OpenBraceToken,
                člani,
                razred.CloseBraceToken,
                razred.SemicolonTokenOpt
            );
            return noviRazred;
        }

        private ConstructorDeclarationSyntax NarediKonstruktorja(ClassDeclarationSyntax razred)
        {
            ConstructorDeclarationSyntax drugi = Syntax.ConstructorDeclaration(
                modifiers: Syntax.TokenList(Syntax.ParseToken("\r\n\tpublic ")),
                identifier: Syntax.Identifier(razred.Identifier.ValueText),
                parameterList: Syntax.ParseParameterList(
                    "(" +
                    polje.Declaration.Type.PlainName + " " + polje.Declaration.Variables[0].Identifier.ValueText +
                    ")"),
                bodyOpt: Syntax.Block(
                    openBraceToken: Syntax.ParseToken("{\r\n"),
                    statements: Syntax.List<StatementSyntax>(new[]{
                        Syntax.ParseStatement(string.Format("this.{0} = {0};", polje.Declaration.Variables[0].Identifier.ValueText)) }),
                    closeBraceToken: Syntax.ParseToken("}\r\n")
                )
            );
            var formattedLocalDeclaration = CodeActionAnnotations.FormattingAnnotation.AddAnnotationTo(drugi);
            return formattedLocalDeclaration;
        }


        private CompilationUnitSyntax DodajUsingsAutofac(CompilationUnitSyntax koren)
        {
            List<UsingDirectiveSyntax> usings = new List<UsingDirectiveSyntax>(koren.Usings);
            UsingDirectiveSyntax autofacUsing = Syntax.UsingDirective(
                name: Syntax.IdentifierName(" Autofac"),
                semicolonToken: Syntax.ParseToken(";\r\n"));
            usings.Add(autofacUsing);
            var newUsings = Syntax.List<UsingDirectiveSyntax>(usings);
            var noviRoot = koren.Update(
                koren.Externs,
                newUsings,
                koren.Attributes,
                koren.Members,
                koren.EndOfFileToken
                );
            return noviRoot;
        }

        public System.Windows.Media.ImageSource Icon
        {
            get { return null; }
        }
    }
}
