using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Threading;
using Roslyn.Compilers;
using Roslyn.Compilers.Common;
using Roslyn.Compilers.CSharp;
using Roslyn.Services;
using Roslyn.Services.Editor;

namespace CodeIssue2
{
    [ExportSyntaxNodeCodeIssueProvider("Posodobi konstruktor", LanguageNames.CSharp, typeof(FieldDeclarationSyntax))]
    class CodeIssueProvider : ICodeIssueProvider
    {
        private readonly ICodeActionEditFactory editFactory;

        [ImportingConstructor]
        public CodeIssueProvider(ICodeActionEditFactory editFactory)
        {
            this.editFactory = editFactory;
        }

        public IEnumerable<CodeIssue> GetIssues(IDocument document, CommonSyntaxNode node, CancellationToken cancellationToken)
        {
            FieldDeclarationSyntax polje = (FieldDeclarationSyntax)node;

            if (polje.Modifiers.Any(m => m.Kind == SyntaxKind.PrivateKeyword) && 
                polje.Modifiers.Any(m => m.Kind == SyntaxKind.ReadOnlyKeyword))
            {
                ISemanticModel sm = document.GetSemanticModel();
                var info = sm.GetSemanticInfo(polje.Declaration.Type);
                if (info.Type.TypeKind == CommonTypeKind.Interface)
                {
                    var konstruktor = (from n in polje.Parent.ChildNodes().OfType<ConstructorDeclarationSyntax>()
                                         select n).SingleOrDefault();
                    bool imaKonstruktor = konstruktor != null;
                    if (!imaKonstruktor)
                        return new[] { 
                            new CodeIssue(CodeIssue.Severity.Info, polje.Span, "Dodaj argument in konstruktorja",
                                new Autofacaj(editFactory, document, polje, null)) };
                    else
                    {
                        bool argumentDeclared = (from p in konstruktor.ParameterList.Parameters
                                                 let i = sm.GetSemanticInfo(p.TypeOpt)
                                                 where i.Type == info.Type
                                                 select p).Any();
                        if (!argumentDeclared)
                            return new[] { new CodeIssue(CodeIssue.Severity.Info, polje.Span, "Dodaj argument",
                                new Autofacaj(editFactory, document, polje, konstruktor)) };
                    }
                }
            }
            return null;
        }

        #region Unimplemented ICodeIssueProvider members

        public IEnumerable<CodeIssue> GetIssues(IDocument document, CommonSyntaxToken token, CancellationToken cancellationToken)
        {
            throw new NotImplementedException();
        }

        public IEnumerable<CodeIssue> GetIssues(IDocument document, CommonSyntaxTrivia trivia, CancellationToken cancellationToken)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
